
#include <iostream>
#include <fstream>

#define MAX 100000

using namespace std;


//#########################################################################
//#				HEAP					  #
//#########################################################################

class CHeap {
	public:
		int *H,n;
		void init(int H[]) { this->H=H; n=0;}
		void clear() { n=0;}
		virtual int comp(int x,int y)  { return (H[x]<H[y]);};
		virtual void swap(int i,int o) { int tmp=H[i]; H[i]=H[o]; H[o]=tmp;};
		void up(int ps);
		void down(int ps);
		void add(int el) { H[++n]=el; up(n);}
		int delroot() {int  el=H[1]; swap(1,n); n--; down(1); return el;}
		int empty() { return (n==0);}
};

void CHeap::up(int ps)
{  int i=ps, o;
   while (i>1)
   { o=i/2;
   if  (comp(i,o)) { swap(i,o); i=o;} else i=0;
   }
}

void CHeap::down(int ps)
{  int i=ps, ns;
   while (2*i<=n)
   { ns=2*i;
   if (ns+1<=n) if (comp(ns+1,ns)) ns++;
   if  (comp(ns,i)) { swap(i,ns); i=ns;} else i=n+1;
   }
}

class CHeapInx : public CHeap {
	public:
		int *T;
		void init(int H[], int T[]) { this->T=T; CHeap::init(H); }
		virtual int comp(int x,int y)  { return (T[H[x]]<T[H[y]]);};
};

class CHeapInxDyn : public CHeapInx {
	public:
		int *PS;
		void init(int H[], int T[], int PS[]) { this->PS=PS; CHeapInx::init(H,T);}
		void add(int el) { PS[el]=n+1; CHeapInx::add(el);}
		virtual void mod(int x,int w)  { T[x]=w; up(PS[x]); };
		virtual void swap(int i,int o) {  int t1=H[i], t2=H[o];
			PS[t1]=o; PS[t2]=i;
			CHeapInx::swap(i,o);
		};
};


int TEMP[10000], VAR[10000], PS[100000],MOD[100000];


//#########################################################################
//#				GRAF					  #
//#########################################################################

class graf {
	public:
		int T[MAX], w, n; 
		// T - tablica gdzie przech. cay graf wg przepisu
		// T[1..n] - indeksy pierwszych nastpnikw
		// T[n+] - "dane" wzw, tzn: nr wza,waga poczenia,indeks do kolejnrgo nastpnika (jeli nie ma to 0)
 		// w - indeks do tablicy
		// n - liczba wzw
		char nazwa_pliku[20];	

	graf(char nazwaP[20]) {	//konstruktor, zerowanie tablicy
		for (int i=0; i<MAX; i++) {
			T[i]=0;
			};
		strcpy(nazwa_pliku,nazwaP);
		};

	int first(int k) {	//zwraca indeks pierwszego nastpnika
		return T[k];
		};
	void next(int &wsk) {	// zmienia wsk na indeks kolejnego nastepnika
		wsk=T[wsk+2];
		};

	int wczytaj_z_pliku();
		

};

int graf::wczytaj_z_pliku(){

	int wez,wag,m; // dane pomocnicze do odczytywania tablicy grafu
	ifstream plik;
	plik.open(nazwa_pliku);
	
	plik >> n;
	
	
	w=n+1;	// pocztek ideksw dla "danych" wezw
	
	for (int i=1; i<=n ;i++){	//czytamy po koleji kazdy weze, do n
		
		plik >> m;		//tu sprawdzamy ile wezel ma gazi
		for (int j=0; j<m; j++){	//i po koleji sczytujemy wszystkie nastpniki
			plik >> wez;
			plik >> wag;
			if(T[i]!=0){	//jeli jest wiecej ni 1 nastpnik,warunek if moe by prawd tylko dla m>1, czyli wiecj ni 1 nastpnik
				T[w+2]=T[i];	
			}
			else	T[w+2]=0; // nie ma ju nastepnikow
			
			T[i]=w;	//ustawiamy indeks 1go nastpnika
			T[w]=wez; //nr wza bedcego nastpnikiem
			T[w+1]=wag; //waga poczenia
			w=w+3; //przestawienie w na kolejn woln pozycj w tablicy "danych" wzw
			
		};
	
	};
	plik.close();
	return n;
};

//#########################################################################
//#				MAIN					  #
//#########################################################################
// MINIMALNE DRZEWO ROZPINAJCE

int main (int argc, char* argv[]){

	if (argc<2){
		cerr<<"Podaj plik z danymi:"<<endl<<argv[0]<<" plik_danych"<<endl;
		return 1;
	};
	
	graf G(argv[1]);
	
	int n=G.wczytaj_z_pliku();

	for (int i=1;i<=n; i++){
		VAR[i]=1000;
		MOD[i]=0;
	};	//ustawienie duych wag dla kadego elementu kopca (niesonczono)

	CHeapInxDyn kdyn;	// budowa kopca
	kdyn.init(TEMP,VAR,PS);
	kdyn.clear();
	
	for(int i=1; i<=n; i++) kdyn.add(i);	//wrzucenie n elementw do kopca
	
	kdyn.mod(1,0);	//wez pierwszy wybieramy jako punkt startu
	
	int x, pom, nast, waga;
	
	// wyszukiwanie najmniejszych wag do kolejnych wzw
	while ( !kdyn.empty() ){
		x=kdyn.delroot(); //usuwamy najmniejszy i dostajemy jego indeks
		MOD[x]=1;	//znacznik przetworzenia wza
		pom=G.first(x);	//"adres" pierwszego nastpnika
		 
		while(pom!=0){	//dopki s nastpniki:
			nast=G.T[pom];	//nr nastpnika
			waga=G.T[pom+1];	//waga poczenia
			//cout << nast << ":" << waga << "  "
			if( (VAR[nast]>waga) && (MOD[nast]==0) ){ //jeli nie by jeszcze usunity, to gdy znajdziemy mniejsz wag to mu j wpisujemy
				kdyn.mod(nast,waga);
			};
			G.next(pom);	//bierzemy indeks nastpnego nastpnika do analizy wag pocze
		};
	};
	
	int suma=0;
	for (int i=1; i<=n; i++) suma+=VAR[i]; //sumowanie
	cout << "wartosc minimalnego drzewa rozpinajacego: " << suma << endl;
	return 0;
	
};



